 

Option Explicit

Dim StdIn:  Set StdIn = WScript.StdIn
Dim StdOut: Set StdOut = WScript
dim connString
dim database
dim folder
dim oSql: 

const SQLDMODep_Children = 262144               'List all Microsoft SQL Server components that depend on the referenced SQL Server component.
const SQLDMODep_IncludeHeader = 131072        'add a datetime header
const SQLDMOScript_DRI_AllConstraints = 520093696 'SQLDMOScript_DRI_Checks, SQLDMOScript_DRI_Defaults, SQLDMOScript_DRI_ForeignKeys, SQLDMOScript_DRI_PrimaryKey, and SQLDMOScript_DRI_UniqueKeys 
const SQLDMOScript_ToFileOnly = 64              'output file
const SQLDMOScript_OwnerQualify =  262144       'object owner
const SQLDMOScript_PrimaryObject = 4            'Generate Transact-SQL creating the referenced component.
const SQLDMOScript_ObjectPermissions = 2        'Include Transact-SQL privilege defining statements when scripting database objects.
const SQLDMOScript_IncludeIfNotExists =4096     'if exists
const SQLDMOScript_Indexes = 73736              'indexs
const SQLDMOScript2_NoCollation = 8388608       'no collation
const SQLDMOScript_Triggers = 16                'triggers
const SQLDMOScript_Drops = 1                   'Generate Transact-SQL to remove the referenced component. Script tests for existence prior attempt to remove component.

const SQLDMOScript_DRI_NonClustered = 4194304
const SQLDMOScript_DRI_Clustered = 8388608
const SQLDMOScript_DRI_Checks = 16777216
const SQLDMOScript_DRI_Defaults = 33554432
const SQLDMOScript_DRI_UniqueKeys = 67108864
const SQLDMOScript_DRI_ForeignKeys = 134217728
const SQLDMOScript_DRI_PrimaryKey = 268435456
const SQLDMOScript_DRI_AllKeys = 469762048
const SQLDMOScript_DRIWithNoCheck = 536870912
const SQLDMOScript_DRI_All = 532676608
const SQLDMOScript_NoIdentity = 1073741824

const PROC_FOLDER = "\stored procedures"
const VIW_FOLDER ="\views"
const UDF_FOLDER = "\functions"
const TAB_FOLDER ="\tables"

Main

sub Main
           
   'get the parameter list   
   dim objArgs: Set objArgs = WScript.Arguments

   if objArgs.Count > 2 then
      connString = objArgs(0)   'connection   
      database = objArgs(1)     'database
      folder = objArgs(2)       'output folder      
      
      dim user
      dim pw
      
      Set oSql = WScript.CreateObject("SQLDMO.SQLServer2")      
      
      if objArgs.Count > 4 then
			user = objArgs(3) 
			pw = objArgs(4) 
			StdOut.Echo "SQL Authentication - Connection to database"
			oSql.LoginSecure = False			'sql authentication 
			oSql.Connect connString ,user,pw   
      else
			StdOut.Echo "windows Authentication - Connection to database"
			oSql.LoginSecure = True   'windows authentication 
			oSql.Connect connString   
	  end if
                                                  
      call ScriptObjects(oSql.Databases(database).Tables,"TAB","Reading tables: ")
      call ScriptObjects(oSql.Databases(database).Views,"VIW","Reading views: ")      
      call ScriptObjects(oSql.Databases(database).StoredProcedures,"PRC","Reading procedures: ")      
      call ScriptObjects(oSql.Databases(database).UserDefinedFunctions,"UDF","Reading functions: ")      
                      
      oSql.Disconnect     
      
   else
      StdOut.Echo "Usage: sqlextract.vbs [server or sql instance name] [database] [output folder]"   
   end if

    set oSql = nothing  
    
    if err.Description <> "" then        
		StdOut.Echo err.Description
	end if

end sub


'GetFolderName
'
'resolves the folder name based on the file ext
'
' ext  - extension name
'
function GetFolderName(ext)

   
   dim tmpFolder
   tmpFolder = ""

   select case ext
      	case "TAB" tmpFolder = TAB_FOLDER 
	case "VIW" tmpFolder = VIW_FOLDER 
	case "PRC" tmpFolder = PROC_FOLDER 
	case "UDF" tmpFolder = UDF_FOLDER 
    end select

    CreateFolder folder + tmpFolder
    GetFolderName = folder  + tmpFolder

end function

'CreateFolder
'
'creates a folder to write files to
'
'path the path to the new folder
sub CreateFolder(path) 
	Dim fso
	Set fso = CreateObject("Scripting.FileSystemObject")
	
	if not fso.FolderExists(path) then
		fso.CreateFolder(path)
	end if

	set fso=nothing

end sub

'ScriptObjects
'
'scrips all the objects
'
' list   - collection
' ext    - extension name to use
' msg    - message to display
sub ScriptObjects(list,ext,msg)

 
    Dim object
    StdOut.Echo ""
    StdOut.Echo msg 
    
    'set the scripting options
    dim options
    options = SQLDMOScript_Indexes _
			OR SQLDMOScript_Drops _
			OR SQLDMOScript_IncludeIfNotExists _
			OR SQLDMOScript_OwnerQualify _
			OR SQLDMOScript_PrimaryObject _
			Or SQLDMODep_Children _
			Or SQLDMOScript_DRI_AllConstraints _
			Or SQLDMODep_IncludeHeader _
			Or SQLDMOScript_ObjectPermissions _
			Or SQLDMOScript_ToFileOnly _
			OR SQLDMOScript2_NoCollation _
			OR SQLDMOScript_Triggers _
			OR SQLDMOScript_DRI_All
    
    For Each object In list
    
		If Not object.SystemObject Then
			StdOut.Echo object.Name			                                                
			object.Script options, GetFolderName(ext)   + "\" + object.Owner + "." + object.Name + "." + ext  	                                                          
		End If
    
    Next
    
end sub


